## Dialogue and Interactive Systems

#### 2020

| Title | Summary | Paper Source | TL;DR |
| ----- | ------- | ----- | ---- |
| Towards a Human-like Open-Domain Chatbot | [Google AI Blog](https://ai.googleblog.com/2020/01/towards-conversational-agent-that-can.html) | [Paper](https://arxiv.org/abs/2001.09977) | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems)

#### 2019

| Title | Summary | Paper Source | TL;DR |
| ----- | ------- | ----- | ----- |
| What makes a good conversation? How controllable attributes affect human judgements | [Abigail See](http://www.abigailsee.com/2019/08/13/what-makes-a-good-conversation.html)| [Paper](https://www.aclweb.org/anthology/N19-1170/) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#what-makes-a-good-conversation-how-controllable-attributes-affect-human-judgments-chat)
| Learning from Dialogue after Deployment: Feed Yourself, Chatbot! | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://www.aclweb.org/anthology/P19-1358) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#learning-from-dialogue-after-deployment-feed-yourself-chatbot-chat)
| TransferTransfo: A Transfer Learning Approach for Neural Network Based Conversational Agents | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1901.08149.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#transfertransfo-a-transfer-learning-approach-for-neural-network-based-conversational-agents-chat)
| Learning to Select Knowledge for Response Generation in Dialog Systems | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://www.ijcai.org/proceedings/2019/0706.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#learning-to-select-knowledge-for-response-generation-in-dialog-systems-chat)
| Consistent Dialogue Generation with Self-supervised Feature Learning | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1903.05759.pdf) |  [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#consistent-dialogue-generation-with-self-supervised-feature-learning-chat)
| Evaluating Coherence in Dialogue Systems using Entailment | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1904.03371.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#evaluating-coherence-in-dialogue-systems-using-entailment-chat)
| Pretraining Methods for Dialog Context Representation Learning | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://www.aclweb.org/anthology/P19-1373) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#pretraining-methods-for-dialog-context-representation-learning-chat)
| Self-Supervised Dialogue Learning | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1907.00448.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#self-supervised-dialogue-learning-chat)
| Structured Fusion Networks for Dialog | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1907.10016.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#structured-fusion-networks-for-dialog-chat)
| Investigating Evaluation of Open-Domain Dialogue Systems With Human Generated Multiple References | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1907.10568.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#investigating-evaluation-of-open-domain-dialogue-systems-with-human-generated-multiple-references-chat)
| Multi-Granularity Representations of Dialog | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1908.09890.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#multi-granularity-representations-of-dialog-chat)

#### 2018

| Title | Summary | Paper Source | TL;DR |
| ----- | ----- | ----- | ---- |
| Personalizing Dialogue Agents: I have a dog, do you have pets too? | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1801.07243.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#personalizing-dialogue-agents-i-have-a-dog-do-you-have-pets-too-chat)
| Building a Conversational Agent Overnight with Dialogue Self-Play | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1801.04871.pdf) |[Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#building-a-conversational-agent-overnight-with-dialogue-self-play-chat)
| Topic-based Evaluation for Conversational Bots  | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1801.03622.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#topic-based-evaluation-for-conversational-bots-chat)
| Improving Variational Encoder-Decoders in Dialogue Generation | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1802.02032.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#improving-variational-encoder-decoders-in-dialogue-generation-chat)
| A Hierarchical Latent Structure for Variational Conversation Modeling | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1804.03424.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#a-hierarchical-latent-structure-for-variational-conversation-modeling-chat)
| Unsupervised Discrete Sentence Representation Learning for Interpretable Neural Dialog Generation | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1804.08069.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#unsupervised-discrete-sentence-representation-learning-for-interpretable-neural-dialog-generation-chat)
| Sounding Board: A User-Centric and Content-Driven Social Chatbot | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) |[Paper](https://arxiv.org/pdf/1804.10202.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#sounding-board-a-user-centric-and-content-driven-social-chatbot-chat)
| DialogWAE: Multimodal Response Generation with Conditional Wasserstein Auto-Encoder | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1805.12352.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#dialogwae-multimodal-response-generation-with-conditional-wasserstein-auto-encoder-chat)
| Reinforcing Coherence for Sequence to Sequence Model in Dialogue Generation | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](http://www.bigdatalab.ac.cn/~junxu/publications/IJCAI2018-DialogueGen.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#reinforcing-coherence-for-sequence-to-sequence-model-in-dialogue-generation-chat)
| Learning to Ask Questions in Open-domain Conversational Systems with Typed Decoders | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1805.04843.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#learning-to-ask-questions-in-open-domain-conversational-systems-with-typed-decoders-chat)
| Multi-turn Dialogue Response Generation in an Adversarial Learning Framework | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1805.11752.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#multi-turn-dialogue-response-generation-in-an-adversarial-learning-framework-chat)
| Zero-Shot Dialog Generation with Cross-Domain Latent Actions | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1805.04803.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#zero-shot-dialog-generation-with-cross-domain-latent-actions-chat)
| Towards Explainable and Controllable Open Domain Dialogue Generation with Dialogue Acts | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) |[Paper](https://arxiv.org/pdf/1807.07255.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#towards-explainable-and-controllable-open-domain-dialogue-generation-with-dialogue-acts-chat)
| Why Do Neural Response Generation Models Prefer Universal Replies? | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1808.09187.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#why-do-neural-response-generation-models-prefer-universal-replies-chat)
| Aiming to Know You Better Perhaps Makes Me a More Engaging Dialogue Partner | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1808.07104.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#aiming-to-know-you-better-perhaps-makes-me-a-more-engaging-dialogue-partner-chat)
| Generating More Interesting Responses in Neural Conversation Models with Distributional Constraints | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1809.01215.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#generating-more-interesting-responses-in-neural-conversation-models-with-distributional-constraints-chat)
| Adversarial Over-Sensitivity and Over-Stability Strategies for Dialogue Models | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1809.02079.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#adversarial-over-sensitivity-and-over-stability-strategies-for-dialogue-models-chat)
| Training Millions of Personalized Dialogue Agents | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1809.01984.pdf) |  [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#training-millions-of-personalized-dialogue-agents-chat)
| Generating Informative and Diverse Conversational Responses via Adversarial Information Maximization | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1809.05972.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#generating-informative-and-diverse-conversational-responses-via-adversarial-information-maximization-chat)
| Better Conversations by Modeling, Filtering, and Optimizing for Coherence and Diversity | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1809.06873.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#better-conversations-by-modeling-filtering-and-optimizing-for-coherence-and-diversity-chat)
| A Dataset for Document Grounded Conversations | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1809.07358.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#a-dataset-for-document-grounded-conversations-chat)
| Talking to myself: self-dialogues as data for conversational agents | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1809.06641.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#talking-to-myself-self-dialogues-as-data-for-conversational-agents-chat)
| Neural Approaches to Conversational AI | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1809.08267.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#neural-approaches-to-conversational-ai-chat)
| Contextual Topic Modeling for Dialog Systems | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) |[Paper](https://arxiv.org/pdf/1810.08135.pdf)| [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#contextual-topic-modeling-for-dialog-systems-chat)
| Automatic Evaluation of Neural Personality-based Chatbots | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1810.00472.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#automatic-evaluation-of-neural-personality-based-chatbots-chat)
| NEXUS Network: Connecting the Preceding and the Following in Dialogue Generation | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1810.00671.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#nexus-network-connecting-the-preceding-and-the-following-in-dialogue-generation-chat)
| MultiWOZ - A Large-Scale Multi-Domain Wizard-of-Oz Dataset for Task-Oriented Dialogue Modelling | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1810.00671.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#multiwoz---a-large-scale-multi-domain-wizard-of-oz-dataset-for-task-oriented-dialogue-modelling-chat)
| The RLLChatbot: a solution to the ConvAI challenge | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1811.02714.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#the-rllchatbot-a-solution-to-the-convai-challenge-chat)
| Neural Response Ranking for Social Conversation: A Data-Efficient Approach | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1811.00967.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#neural-response-ranking-for-social-conversation-a-data-efficient-approach-chat)
| Generating Multiple Diverse Responses for Short-Text Conversation | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1811.05696.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#generating-multiple-diverse-responses-for-short-text-conversation-chat)
| Wizard of Wikipedia: Knowledge-Powered Conversational agents | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1811.01241.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#wizard-of-wikipedia-knowledge-powered-conversational-agents-chat)
| Importance of a Search Strategy in Neural Dialogue Modelling | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1811.00907.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#importance-of-a-search-strategy-in-neural-dialogue-modelling-chat)
| A Study on Dialogue Reward Prediction for Open-Ended Conversational Agents | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1812.00350.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#a-study-on-dialogue-reward-prediction-for-open-ended-conversational-agents-chat)

#### 2017

| Title | Summary | Paper Source | TL;DR |
| ----- | ----- | ----- | ---- |
| RUBER: An Unsupervised Method for Automatic Evaluation of Open-Domain Dialog Systems| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1701.03079.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#ruber-an-unsupervised-method-for-automatic-evaluation-of-open-domain-dialog-systems-chat)
| Adversarial Learning for Neural Dialogue Generation| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1701.06547.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#adversarial-learning-for-neural-dialogue-generation-chat)
| Hierarchical Recurrent Attention Network for Response Generation| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems)  | [Paper](https://arxiv.org/pdf/1701.07149.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#hierarchical-recurrent-attention-network-for-response-generation-chat)
| A Copy-Augmented Sequence-to-Sequence Architecture Gives Good Performance on Task-Oriented Dialogue| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1701.04024.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#a-copy-augmented-sequence-to-sequence-architecture-gives-good-performance-on-task-oriented-dialogue-chat)
| Generating High-Quality and Informative Conversation Responses with Sequence-to-Sequence Models| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1701.03185.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#generating-high-quality-and-informative-conversation-responses-with-sequence-to-sequence-models-chat)
| A Knowledge-Grounded Neural Conversation Model| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1702.01932.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#a-knowledge-grounded-neural-conversation-model-chat)
| Batch Policy Gradient Methods for Improving Neural Conversation Models| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1702.03334.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#batch-policy-gradient-methods-for-improving-neural-conversation-models-chat)
| Hybrid Code Networks: practical and efficient end-to-end dialog control with supervised and reinforcement learning| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) |[Paper](https://arxiv.org/pdf/1702.03274.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#hybrid-code-networks-practical-and-efficient-end-to-end-dialog-control-with-supervised-and-reinforcement-learning-chat)
| Learning Conversational Systems that Interleave Task and Non-Task Content | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1703.00099.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#learning-conversational-systems-that-interleave-task-and-non-task-content-chat)
| Learning Discourse-level Diversity for Neural Dialog Models using Conditional Variational Autoencoders| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1703.10960.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#learning-discourse-level-diversity-for-neural-dialog-models-using-conditional-variational-autoencoders-chat)
| Emotional Chatting Machine: Emotional Conversation Generation with Internal and External Memory| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1704.01074.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#emotional-chatting-machine-emotional-conversation-generation-with-internal-and-external-memory-chat)
| Not All Dialogues are Created Equal: Instance Weighting for Neural Conversational Models| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1704.08966.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#not-all-dialogues-are-created-equal-instance-weighting-for-neural-conversational-models-chat)
| Chat Detection in an Intelligent Assistant: Combining Task-oriented and Non-task-oriented Spoken Dialogue Systems| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1705.00746.pdf) |  [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#chat-detection-in-an-intelligent-assistant-combining-task-oriented-and-non-task-oriented-spoken-dialogue-systems-chat)
| A Conditional Variational Framework for Dialog Generation| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1705.00316.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#a-conditional-variational-framework-for-dialog-generation-chat)
| ParlAI: A Dialog Research Software Platform| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1705.06476.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#parlai-a-dialog-research-software-platform-chat)
| Emergence of Language with Multi-agent Games: Learning to Communicate with Sequences of Symbols| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1705.11192.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#emergence-of-language-with-multi-agent-games-learning-to-communicate-with-sequences-of-symbols-chat)
| Generative Encoder-Decoder Models for Task-Oriented Spoken Dialog Systems with Chatting Capability| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1706.08476.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#generative-encoder-decoder-models-for-task-oriented-spoken-dialog-systems-with-chatting-capability-chat)
| Personalization in Goal-Oriented Dialog| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/ftp/arxiv/papers/1706/1706.07503.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#personalization-in-goal-oriented-dialog-chat)
| Natural Language Does Not Emerge ‘Naturally’ in Multi-Agent Dialog| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) |[Paper](https://arxiv.org/pdf/1706.08502.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#natural-language-does-not-emerge-naturally-in-multi-agent-dialog-chat)
| Deal or No Deal? End-to-End Learning for Negotiation Dialogues| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1706.05125.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#deal-or-no-deal-end-to-end-learning-for-negotiation-dialogues-chat)
| DeepProbe: Information Directed Sequence Understanding and Chatbot Design via Recurrent Neural Networks| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1707.05470.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#deepprobe-information-directed-sequence-understanding-and-chatbot-design-via-recurrent-neural-networks-chat)
| Enterprise to Computer: Star Trek chatbot| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1708.00818.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#enterprise-to-computer-star-trek-chatbot-chat)
| Domain Aware Neural Dialog System| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1708.00897.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#domain-aware-neural-dialog-system-chat)
| Towards an Automatic Turing Test: Learning to Evaluate Dialogue Responses| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1708.07149.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#towards-an-automatic-turing-test-learning-to-evaluate-dialogue-responses-chat)
| A Deep Reinforcement Learning Chatbot| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1709.02349.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#a-deep-reinforcement-learning-chatbot-chat)
| Challenging Neural Dialogue Models with Natural Data: Memory Networks Fail on Incremental Phenomena| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1709.07840.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#challenging-neural-dialogue-models-with-natural-data-memory-networks-fail-on-incremental-phenomena-chat)
| Flexible End-to-End Dialogue System for Knowledge Grounded Conversation| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1709.04264.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#flexible-end-to-end-dialogue-system-for-knowledge-grounded-conversation-chat)
| Edina: Building an Open Domain Socialbot with Self-dialogues| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1709.09816.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#edina-building-an-open-domain-socialbot-with-self-dialogues-chat)
| Interactive Policy Learning In End-to-End Trainable Task-Oriented Neural Dialog Models| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1709.06136.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#interactive-policy-learning-in-end-to-end-trainable-task-oriented-neural-dialog-models-chat)
| Augmenting End-to-End Dialog Systems with Commonsense Knowledge| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1709.05453v1.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#augmenting-end-to-end-dialog-systems-with-commonsense-knowledge-chat)
| Multi-Task Learning for Speaker-Role Adaptation in Neural Conversation Models| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1710.07388.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#multi-task-learning-for-speaker-role-adaptation-in-neural-conversation-models-chat)
| DailyDialog: A Manually Labelled Multi-turn Dialogue Dataset| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems)  |[Paper](https://arxiv.org/pdf/1710.03957.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#dailydialog-a-manually-labelled-multi-turn-dialogue-dataset-chat)
| A Dual Encoder Sequence to Sequence Model for Open-Domain Dialogue Modeling| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems)  | [Paper](https://arxiv.org/pdf/1710.10520.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#a-dual-encoder-sequence-to-sequence-model-for-open-domain-dialogue-modeling-chat)
| Adversarial Advantage Actor-Critic Model For Task-Completion Dialogue Policy Learning| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1710.11277.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#adversarial-advantage-actor-critic-model-for-task-completion-dialogue-policy-learning-chat)
| Customized Nonlinear Bandits for Online Response Selection in Neural Conversation Models| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1711.08493.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#customized-nonlinear-bandits-for-online-response-selection-in-neural-conversation-models-chat)
| End-to-end Adversarial Learning for Generative Conversational Agents| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1711.10122.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#end-to-end-adversarial-learning-for-generative-conversational-agents-chat)
| Fine Grained Knowledge Transfer for Personalized Task-oriented Dialogue Systems| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1711.04079.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#fine-grained-knowledge-transfer-for-personalized-task-oriented-dialogue-systems-chat)
| BBQ-Networks: Efficient Exploration in Deep Reinforcement Learning for Task-Oriented Dialogue Systems|  [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems)|  [Paper](https://arxiv.org/pdf/1711.05715v1.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#bbq-networks-efficient-exploration-in-deep-reinforcement-learning-for-task-oriented-dialogue-systems-chat)
| End-to-End Optimization of Task-Oriented Dialogue Model with Deep Reinforcement Learning| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1711.10712.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#end-to-end-optimization-of-task-oriented-dialogue-model-with-deep-reinforcement-learning-chat)
| Are You Talking to Me? Reasoned Visual Dialog Generation through Adversarial Learning| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1711.07613.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#are-you-talking-to-me-reasoned-visual-dialog-generation-through-adversarial-learning-chat)
| RubyStar: A Non-Task-Oriented Mixture Model Dialog System| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1711.02781.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#rubystar-a-non-task-oriented-mixture-model-dialog-system-chat)
| Examining Cooperation in Visual Dialog Models| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1712.01329.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#examining-cooperation-in-visual-dialog-models-chat)
| Why Do Neural Dialog Systems Generate Short and Meaningless Replies? A Comparison between Dialog and Translation| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1712.02250.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#why-do-neural-dialog-systems-generate-short-and-meaningless-replies-a-comparison-between-dialog-and-translation-chat)
| End-to-End Offline Goal-Oriented Dialog Policy Learning via Policy Gradient| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1712.02838.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#end-to-end-offline-goal-oriented-dialog-policy-learning-via-policy-gradient-chat)
| Toward Continual Learning for Conversational Agents| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) |[Paper](https://arxiv.org/pdf/1712.09943.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#toward-continual-learning-for-conversational-agents-chat)
| An Ensemble Model with Ranking for Social Dialogue| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) |  [Paper](https://arxiv.org/pdf/1712.07558.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#an-ensemble-model-with-ranking-for-social-dialogue-chat)

#### 2016

| Title | Summary | Paper Source | TL;DR |
| ----- | ------- | ----- | ----- |
| Incorporating Copying Mechanism in Sequence-to-Sequence Learning| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1603.06393.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#incorporating-copying-mechanism-in-sequence-to-sequence-learning-chat)
| A Persona-Based Neural Conversation Model| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1603.06155.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#a-persona-based-neural-conversation-model-chat)
| How NOT To Evaluate Your Dialogue System: An Empirical Study of Unsupervised Evaluation Metrics for Dialogue Response Generation| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1603.08023.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#how-not-to-evaluate-your-dialogue-system-an-empirical-study-of-unsupervised-evaluation-metrics-for-dialogue-response-generation-chat)
| StalemateBreaker: A Proactive Content-Introducing Approach to Automatic Human-Computer Conversation| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1604.04358.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#stalematebreaker-a-proactive-content-introducing-approach-to-automatic-human-computer-conversation-chat)
| A Network-based End-to-End Trainable Task-oriented Dialogue System| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1604.04562.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#a-network-based-end-to-end-trainable-task-oriented-dialogue-system-chat)
| A Hierarchical Latent Variable Encoder-Decoder Model for Generating Dialogues| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1605.06069.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#a-hierarchical-latent-variable-encoder-decoder-model-for-generating-dialogues-chat)
| Deep Reinforcement Learning for Dialogue Generation| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1606.01541.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#deep-reinforcement-learning-for-dialogue-generation-chat)
| An Attentional Neural Conversation Model with Improved Specificity| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1606.01292.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#an-attentional-neural-conversation-model-with-improved-specificity-chat)
| Topic Aware Neural Response Generation| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1606.08340.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#topic-aware-neural-response-generation-chat)
| Multiresolution Recurrent Neural Networks: An Application to Dialogue Response Generation|  [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1606.00776.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#multiresolution-recurrent-neural-networks-an-application-to-dialogue-response-generation-chat)
| Neural Discourse Modeling of Conversations| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1607.04576.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#neural-discourse-modeling-of-conversations-chat)
| Neural Contextual Conversation Learning with Labeled Question-Answering Pairs| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1607.05809.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#neural-contextual-conversation-learning-with-labeled-question-answering-pairs-chat)
| Sequence to Backward and Forward Sequences: A Content-Introducing Approach to Generative Short-Text Conversation| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1607.00970.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#sequence-to-backward-and-forward-sequences-a-content-introducing-approach-to-generative-short-text-conversation-chat)
| Two are Better than One: An Ensemble of Retrieval- and Generation-Based Dialog Systems| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1610.07149.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#two-are-better-than-one-an-ensemble-of-retrieval-and-generation-based-dialog-systems-chat)
| Dialogue Learning With Human-In-The-Loop| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1611.09823.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#dialogue-learning-with-human-in-the-loop-chat)
| Deep Active Learning for Dialogue Generation| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1612.03929.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#deep-active-learning-for-dialogue-generation-chat)

#### 2015

| Title | Summary | Paper Source | TL;DR |
| ----- | ------- | ----- | ---- |
| Neural Responding Machine for Short-Text Conversation| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1503.02364.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#neural-responding-machine-for-short-text-conversation-chat)
| A Neural Conversational Model| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1506.05869.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#a-neural-conversational-model-chat)
| A Neural Network Approach to Context-Sensitive Generation of Conversational Responses| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1506.06714.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#a-neural-network-approach-to-context-sensitive-generation-of-conversational-responses-chat)
| Building End-To-End Dialogue Systems Using Generative Hierarchical Neural Network Models| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1507.04808.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#building-end-to-end-dialogue-systems-using-generative-hierarchical-neural-network-models-chat)
| A Diversity-Promoting Objective Function for Neural Conversation Models| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1510.03055.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#a-diversity-promoting-objective-function-for-neural-conversation-models-chat)
| Attention with Intention for a Neural Network Conversation Model | [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1510.08565.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#attention-with-intention-for-a-neural-network-conversation-model-chat)
| A Survey of Available Corpora for Building Data-Driven Dialogue Systems| [Contribute ✍️](https://github.com/dair-ai/nlp_paper_summaries/new/master/Dialogue%20and%20Interactive%20Systems) | [Paper](https://arxiv.org/pdf/1512.05742.pdf) | [Richard Csaky](https://github.com/ricsinaruto/Seq2seqChatbots/wiki/Chatbot-and-Related-Research-Paper-Notes-with-Images#a-survey-of-available-corpora-for-building-data-driven-dialogue-systems-chat)
